import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";

const initialState = {
    myWishlist: [],
    loading: true,
    isRefresh: false,
    wishlist: false,
    tempWishlistId: null,
    pagination: {},
};

export const getMyWishlist = createAsyncThunk(
    "user/getMyWishlist",
    async ({ access_token, URL }) => {
        const response = await queryResponse(URL, "GET", access_token);
        return response;
    }
);

const getMyWishlistSlice = createSlice({
    name: "user",
    initialState,
    reducers: {
        resetWishlist: (state) => {
            state.myWishlist = [];
            state.pagination = {};
            state.loading = true;
            state.isRefresh = false;
            state.wishlist = false;
            state.tempWishlistId = null;
        },
        fetchWishlistStart: (state) => {
            state.isRefresh = true;
        },
        getMyAllWishlist: (state, { payload }) => {
            state.myWishlist = payload;
            state.loading = false;
            state.isRefresh = false;
        },
        isWishlist: (state, { payload }) => {
            state.wishlist = payload;
        },
        storeTempWishlist: (state, { payload }) => {
            state.tempWishlistId = payload;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getMyWishlist.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getMyWishlist.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload || {};
            if (code === 200) {
                state.myWishlist = records.data;
                state.pagination = records.pagination;
            } else {
                state.myWishlist = [];
                state.pagination = {};
            }
            state.loading = false;
        });
        builder.addCase(getMyWishlist.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const {
    resetWishlist,
    fetchWishlistStart,
    getMyAllWishlist,
    storeTempWishlist,
    isWishlist,
} = getMyWishlistSlice.actions;

export default getMyWishlistSlice.reducer;
